<?php
define("PRODUCT_ID", '2547547200');
session_start();

$installFile = ".lic";
if (is_writeable($installFile)) {
    die('<h3 style="text-align:center;margin-top:100px;color:red;">The installation process is already complete!</h3>');
}

function getLatestVersion() {
    $data_array = ["method_name" => "latest_version","item_id" => PRODUCT_ID];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.nemosofts.com/v1/market/author");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data_array));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $result = curl_exec($ch);
    curl_close($ch);
    $response = json_decode($result, true);
    return $response ?: ['product_name' => 'Nemosofts Product'];
}
$product_info = getLatestVersion();

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    return $protocol . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']) . "/";
}

$step = $_GET['step'] ?? '';
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo htmlspecialchars($product_info['product_name']); ?> - Installer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">
    <style>
        body{display:flex;justify-content:center;align-items:center;height:100vh;background:#f8f9fa}
        .container-box{padding:10px;width:530px;overflow:hidden}
        .container-nav{display:flex;justify-content:space-between;padding:10px;margin-bottom:10px;background:#f1f3f5;border-radius:8px}
        .nav-link-install{color:rgba(0,0,0,.603);text-decoration:none;font-weight:500;padding:5px 10px;display:flex;align-items:center;gap:5px;font-size:17px}
        .nav-link-install i{font-size:18px}
        .nav-link-install.active{font-weight:700;color:rgba(0,0,0,.747)}
        .nav-link-install.active i{color:#00c20a}
        .container-page{padding:10px;background:#fff;border:1px solid #eee;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,.05)}
        .alert i{font-weight:700;font-size:18px}
        .alert{padding:7px;margin-bottom:7px}
        .btn-warning{width:60px;font-weight:700;background:gold;border:none}
        .input-group-text{background:transparent;border-right:none}
        .form-control{border-left:none;background:#f0f0f0}
    </style>
</head>
<body class="bg-light">
<div class="container-box">
    <div class="mt-3 text-center"><h4><?php echo htmlspecialchars($product_info['product_name']); ?> - Installer</h4></div>

    <?php switch($step):
        default: ?>
            <div class="container-nav">
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Verify</a>
                <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> AdminPanel</a>
                <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Finish</a>
            </div>
            <div class="container-page">
                <?php
                $errors = false;
                if (version_compare(PHP_VERSION, '8.1.0') < 0) {
                    echo '<div class="alert alert-danger"><i class="ri-close-line"></i> PHP 8.1+ required. Current: '.PHP_VERSION.'</div>';
                    $errors = true;
                } else {
                    echo '<div class="alert alert-success"><i class="ri-check-line"></i> PHP Version: '.PHP_VERSION.'</div>';
                }
                $extensions = ['bcmath','ctype','fileinfo','json','mbstring','openssl','pdo','tokenizer','xml','curl','intl'];
                foreach($extensions as $ext) {
                    if (!extension_loaded($ext)) {
                        echo '<div class="alert alert-danger"><i class="ri-close-line"></i> '.$ext.' extension missing!</div>';
                        $errors = true;
                    } else {
                        echo '<div class="alert alert-success"><i class="ri-check-line"></i> '.$ext.' extension loaded</div>';
                    }
                }
                if (!$errors): ?>
                    <div class="mt-3 text-end"><a href="index.php?step=0" class="btn btn-warning">Next</a></div>
                <?php endif; ?>
            </div>
            <?php break;

        case '0': ?>
            <div class="container-nav">
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Verify</a>
                <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> AdminPanel</a>
                <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Finish</a>
            </div>
            <div class="container-page text-center p-5">
                <div class="alert alert-success"><i class="ri-check-line"></i> License verification bypassed</div>
                <form action="index.php?step=1" method="POST">
                    <input type="hidden" name="lcscs" value="true">
                    <button type="submit" class="btn btn-warning mt-3">Next</button>
                </form>
            </div>
            <?php break;

        case '1':
            if (!isset($_POST['lcscs'])) die('<div class="alert alert-danger">Access denied.</div>'); ?>
            <div class="container-nav">
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Verify</a>
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> AdminPanel</a>
                <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Finish</a>
            </div>
            <div class="container-page">
                <?php if (!empty($_POST['host'])) {
                    $admin_url = rtrim(trim($_POST['host']), '/');
                    $content = "CI_ENVIRONMENT = production\n\n";
                    $content .= "app.baseURL = ".getBaseUrl()."\n\n";
                    $content .= "ADMIN_PANEL_URL = $admin_url\n";
                    $content .= "API_HEADER = NEMOSOFTS_WEB\n";
                    file_put_contents('../.env', $content);
                    echo '<div class="alert alert-success"><i class="ri-check-line"></i> Admin panel URL saved!</div>';
                    echo '<form action="index.php?step=2" method="POST"><input type="hidden" name="dbscs" value="true"><div class="text-end"><button type="submit" class="btn btn-warning mt-3">Next</button></div></form>';
                } else { ?>
                    <form action="index.php?step=1" method="POST">
                        <input type="hidden" name="lcscs" value="true">
                        <div class="mt-3">
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-links-line"></i></span>
                                <input name="host" class="form-control" placeholder="https://yourdomain.com/admin" required value="https://">
                            </div>
                        </div>
                        <div class="text-end"><button type="submit" class="btn btn-warning mt-3">Save</button></div>
                    </form>
                <?php } ?>
            </div>
            <?php break;

        case '2':
            if (!isset($_POST['dbscs'])) die('<div class="alert alert-danger">Access denied.</div>');
            file_put_contents('.lic', 'INSTALLED', LOCK_EX);
            session_destroy(); ?>
            <div class="container-nav">
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Verify</a>
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> AdminPanel</a>
                <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Finish</a>
            </div>
            <div class="container-page text-center p-5">
                <div class="alert alert-success fs-4"><i class="ri-check-line"></i> Installation completed successfully!</div>
                <a href="../" class="btn btn-primary btn-lg mt-4">Go to Site</a>
            </div>
            <?php break;
    endswitch; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>